
using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;
using System.IO;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A simple sample for exporting the results of the comparison of 2 PDF Files to a PDF.
    /// Expects 2 arguments - the paths of the PDF files to be compared
    /// </summary>
    public class SimpleCompareAndExport
    {
        static SimpleCompareAndExport()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how exporting the result of a comparison of 2 PDF Files to a PDF,
        /// showing how to set the export path for this comparison report.
        /// </summary>
        /// <param name="args">Expects 2 arguments: the paths of the 2 PDF files that will be compared.</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            // Instantiate a PDF export presenter to write the result of the comparison as a PDF file
            DifferencesPDFPresenter differencesPDFPresenter = new DifferencesPDFPresenter(Path.GetDirectoryName(args[0]));
            using (
                new PDFComparer() // create a comparer instance
                .AddPresenter(differencesPDFPresenter) // add the PDF export as an output format
                .Compare(args[0], args[1])) // run the comparison for the two files passed as arguments
            { }
        }
    }
}